 ; Ŀ
 ;   Dx - remove overrides (which are xdata) from selected dimensions.     
 ;   Copyright 2002, 2005, 2009 by Rocket Software Ltd.                    
 ;   The desire to do things well is often swamped by the burning need     
 ;   to have your own way of doing things and make sure everyone knows.    
 ; 

 ; Ŀ
 ;   Exkill - remove the extended data from an entity.                     
 ;   Amazingly, this works: remove everything from the xdata for the       
 ;   app in question except the app name, entmod it back in, acad          
 ;   ditches the entire app xdata set from that entity.                    
 ;   Completely removing the xdata for that app doesn't work - acad        
 ;   assumes that it isn't touching the xdata for that app at all.         
 ;                                                                         
 ;   Arguments: Enam - the entity name.                                    
 ;              appi - the application to remove the data for.             
 ;   Calls nothing, returns nothing.                                       
 ; 
 (DEFUN EXKILL (enam appi / entt exdat sub nuex)
  (setq entt (entget enam (list "*")))
  (if (setq exdat (assoc -3 entt))
      (progn
           (while (setq sub (car exdat))
                  (setq exdat (cdr exdat))
                  (if (and (= (type sub) 'LIST)
                           (= (car sub) appi))
                      (setq nuex (append nuex (list (list (car sub)))))
                      (setq nuex (append nuex (list sub)))))
           (entmod (append (entget enam) (list nuex)))))
 (princ))
 ; Ŀ
 ;   Exkill end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Cstar - draw an individual grstar (centred).               
 ;   Takes four arguments: centre point, side length, rotation (radians),  
 ;   and colour.  Returns nothing, but draws a star.                       
 ; 
 (DEFUN CSTAR (pa sidlen rota colo / anginc angg hafang pb)
  (setq pa (polar pa (+ rota (/ pi 2)) (* sidlen 1.37638192)))
  (setq anginc (* 1.6 pi))
  (setq angg (+ rota (* 1.6 pi)))
  (setq hafang (* 0.8 pi))
  (repeat 5
         (setq pb (polar pa angg sidlen))
         (grdraw pa pb colo)
         (setq angg (- angg anginc))
         (setq pa pb)
         (setq pb (polar pa angg sidlen))
         (grdraw pa pb colo)
         (setq angg (- angg hafang))
         (setq pa pb))
 (princ))
 ; Ŀ
 ;   Subroutine Cstar end.                                                 
 ; 

 ; Ŀ
 ;   Dx.                                                                   
 ; 
 (DEFUN C:DX (/ rad ss num bb rota)
  (setq rad (/ (getvar "viewsize") 25))
 ; Ŀ
 ;   Get an ss of dimensions.                                              
 ; 
  (setq ss (ssget (list (cons 0 "dimension,leader"))))
  (setq num 0)
  (setq rota 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq bb (entget enam (list "ACAD")))
         (if (assoc -3 bb)
             (progn
                  (exkill enam "ACAD")
                  (cstar (cdr (assoc 10 bb)) rad rota 2)
                  (cstar (cdr (assoc 10 bb)) (* rad 0.9) rota 1)
                  (cstar (cdr (assoc 10 bb)) (* rad 0.8) rota 4)
                  (setq rota (+ rota 12)))))
 (princ))